/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.boat;

import com.renyigesai.immortalers_delight.Config;
import com.renyigesai.immortalers_delight.entities.boat.AncientWoodChestBoat;
import com.renyigesai.immortalers_delight.entities.boat.ImmortalersBoat;
import com.renyigesai.immortalers_delight.entities.boat.ImmortalersChestBoat;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import java.util.ArrayList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AncientWoodBoat
extends ImmortalersBoat {
    public AncientWoodBoat(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AncientWoodBoat(Level level, double pX, double pY, double pZ) {
        this((EntityType<? extends Boat>)((EntityType)ImmortalersDelightEntities.ANCIENT_WOOD_BOAT.get()), level);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    @Override
    public void m_213560_(DamageSource damageSource) {
        this.m_19983_(new ItemStack((ItemLike)ImmortalersDelightItems.ANCIENT_WOOD_LOG.get(), 5));
    }

    public double m_6048_() {
        return 0.25;
    }

    protected boolean m_7310_(@NotNull Entity passenger) {
        if (AncientWoodBoat.passengerSize(passenger) > this.m_213801_() - this.m_20197_().size()) {
            return false;
        }
        return passenger.m_20205_() < 2.5f && super.m_7310_(passenger);
    }

    public boolean m_271938_(Entity pEntity) {
        return (double)pEntity.m_20205_() < 0.8 * (double)this.m_20205_();
    }

    protected int m_213801_() {
        return 5 - this.passengersNeedExtraSeats();
    }

    private static int passengerSize(Entity passenger) {
        return passenger.m_20205_() > 1.8f ? 3 : (passenger.m_20205_() > 1.375f ? 2 : 1);
    }

    private int passengersNeedExtraSeats() {
        int i = 0;
        for (Entity passenger : this.m_20197_()) {
            i += AncientWoodBoat.passengerSize(passenger) - 1;
        }
        return i;
    }

    public static boolean isAnimalEsque(Entity passenger) {
        return passenger instanceof Animal || passenger instanceof HoglinBase || AncientWoodBoat.passengerSize(passenger) > 1 && passenger instanceof Spider;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction function) {
        if (this.m_20363_(passenger)) {
            float x = -0.2f;
            float z = 0.0f;
            int index = this.m_20197_().indexOf(passenger);
            int occupiedSeats = this.passengersNeedExtraSeats();
            boolean rotate = false;
            if (occupiedSeats > 0) {
                ArrayList<Integer> bigPassengerIndex = new ArrayList<Integer>();
                for (int i = 0; i < this.m_20197_().size(); ++i) {
                    if (AncientWoodBoat.passengerSize((Entity)this.m_20197_().get(i)) <= 1) continue;
                    bigPassengerIndex.add(i);
                }
                if (this.m_20197_().size() == 4) {
                    if (AncientWoodBoat.passengerSize(passenger) > 1) {
                        rotate = AncientWoodBoat.isAnimalEsque(passenger);
                        x -= 1.0f;
                    } else {
                        bigIndex = (Integer)bigPassengerIndex.get(0);
                        if (bigIndex == 0 && index == 1 || bigIndex > 0 && index == 0) {
                            x += 1.2f;
                        } else {
                            x += 0.2f;
                            z = index % 2 == 0 ? (z += 0.5f) : (z -= 0.5f);
                        }
                    }
                } else if (this.m_20197_().size() == 3) {
                    if (bigPassengerIndex.size() == 2) {
                        bigIndex = (Integer)bigPassengerIndex.get(0);
                        if (AncientWoodBoat.passengerSize(passenger) > 1) {
                            rotate = AncientWoodBoat.isAnimalEsque(passenger);
                            x -= index == bigIndex ? 1.1f : -0.3f;
                        } else {
                            x += 1.2f;
                        }
                    }
                    if (bigPassengerIndex.size() == 1) {
                        bigIndex = (Integer)bigPassengerIndex.get(0);
                        if (AncientWoodBoat.passengerSize(passenger) > 1) {
                            rotate = AncientWoodBoat.isAnimalEsque(passenger);
                            x -= 0.5f;
                        } else {
                            x += 0.8f;
                            z = bigIndex == 0 && index == 1 || bigIndex > 0 && index == 0 ? (z += 0.5f) : (z -= 0.5f);
                        }
                    }
                } else if (this.m_20197_().size() == 2) {
                    if (bigPassengerIndex.size() == 1) {
                        rotate = AncientWoodBoat.isAnimalEsque(passenger);
                        x = index == 0 ? (x += 0.8f) : (x -= 0.6f);
                    }
                    if (bigPassengerIndex.size() == 2) {
                        if (index == 0) {
                            x += 0.8f;
                        } else {
                            rotate = AncientWoodBoat.isAnimalEsque(passenger);
                            x -= 0.8f;
                        }
                    }
                } else if (this.m_20197_().size() == 1) {
                    x -= 0.4f;
                }
            } else if (this.m_20197_().size() > 4) {
                x = 1.35f - (float)index * 0.7f;
            } else if (this.m_20197_().size() == 4) {
                x = 1.2f - (float)index * 0.8f;
            } else if (this.m_20197_().size() == 3) {
                x = 1.0f - (float)index * 1.0f;
            } else if (this.m_20197_().size() == 2) {
                x += 0.6f - (float)index * 1.4f;
            } else if (this.m_20197_().size() == 1) {
                x += -0.8f;
            }
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            Vec3 vector3d = new Vec3((double)x, 0.0, (double)z).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            function.m_20372_(passenger, this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vector3d.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
            this.m_38321_(passenger);
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                if (rotate || AncientWoodBoat.isAnimalEsque(passenger) && AncientWoodBoat.passengerSize(passenger) == 1 && this.m_20197_().size() > 1) {
                    int j = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                    passenger.m_5618_(living.f_20883_ + (float)j);
                    passenger.m_5616_(passenger.m_6080_() + (float)j);
                }
            }
        }
    }

    @Override
    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack hand = pPlayer.m_21120_(pHand);
        ItemStack otherHand = pPlayer.m_21120_(pHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (this.addChest(hand, pPlayer)) {
            return InteractionResult.SUCCESS;
        }
        if (this.addChest(otherHand, pPlayer)) {
            return InteractionResult.SUCCESS;
        }
        return super.imm$Interact(pPlayer, pHand);
    }

    private boolean addChest(ItemStack hand, Player pPlayer) {
        if (hand.m_204117_(ImmortalersDelightTags.ANCIENT_CHEST_BOAT_NEED_2) && hand.m_41613_() >= Config.ancientBoatNeeded_2) {
            AncientWoodChestBoat boat = new AncientWoodChestBoat(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!pPlayer.m_150110_().f_35937_) {
                hand.m_41774_(Config.ancientBoatNeeded_2);
            }
            boat.setVariant(ImmortalersChestBoat.Type.ANCIENT_WOOD);
            this.m_9236_().m_7967_((Entity)boat);
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12630_, SoundSource.BLOCKS, 0.8f, 0.8f, false);
            this.m_146870_();
            return true;
        }
        return false;
    }
}

